#include "etpan-preferences-view.h"

#include "etpan-backend.h"
#include "etpan-preferences-window.h"
#include "etpan-ui-config.h"
#include "etpan-icon-manager.h"

/*
  message view page
  - font
  - message colors (in fact, in contextual menu)
*/

#define PADDING 5

#define COLOR_NAME_COL_WIDTH 100
#define COLOR_NAME_MIN_WIDTH 10

static void setup_panel(struct etpan_preferences_panel * panel);
static void panel_close(struct etpan_preferences_panel * panel);

static void font_other_changed(GtkFontButton * widget, gpointer user_data)
{
  GtkWidget * chooser_font;
  struct etpan_preferences_panel * panel;
  const char * font_name;
  (void) widget;
  
  panel = user_data;
  
  chooser_font = etpan_preferences_panel_get_widget(panel, "font-other");
  font_name = gtk_font_button_get_font_name(GTK_FONT_BUTTON(chooser_font));

  ETPAN_LOG("font : %s", font_name);
  
  etpan_ui_config_set_font_other(etpan_ui_config_get_default(),
      (char *) font_name);
}

static void font_list_changed(GtkFontButton * widget, gpointer user_data)
{
  GtkWidget * chooser_font;
  struct etpan_preferences_panel * panel;
  const char * font_name;
  (void) widget;
  
  panel = user_data;
  
  chooser_font = etpan_preferences_panel_get_widget(panel, "font-list");
  font_name = gtk_font_button_get_font_name(GTK_FONT_BUTTON(chooser_font));
  ETPAN_LOG("font : %s", font_name);

  etpan_ui_config_set_font_list(etpan_ui_config_get_default(),
      (char *) font_name);
}

static void font_message_changed(GtkFontButton * widget, gpointer user_data)
{
  GtkWidget * chooser_font;
  struct etpan_preferences_panel * panel;
  const char * font_name;
  (void) widget;
  
  panel = user_data;
  
  chooser_font = etpan_preferences_panel_get_widget(panel, "font-message");
  font_name = gtk_font_button_get_font_name(GTK_FONT_BUTTON(chooser_font));
  ETPAN_LOG("font : %s", font_name);

  etpan_ui_config_set_font_message(etpan_ui_config_get_default(),
      (char *) font_name);
}

static void attachment_folder_changed(GtkFileChooser * chooser, gpointer user_data)
{
  GtkWidget * chooser_folder;
  struct etpan_preferences_panel * panel;
  char * filename;
  (void) chooser;
  
  panel = user_data;
  chooser_folder = etpan_preferences_panel_get_widget(panel, "attachment-folder");
  filename = gtk_file_chooser_get_filename(GTK_FILE_CHOOSER(chooser_folder));
  
  etpan_global_config_set_attachment_folder(etpan_global_config_get_default(),
      filename);
  
  if (filename != NULL)
    g_free(filename);
}

static void message_view_properties_content(struct etpan_preferences_panel * panel,
    GtkWidget * table)
{
  guint gline;
  int line;
  GtkWidget * label_font_message;
  GtkWidget * label_font_list;
  GtkWidget * label_font_other;
  GtkWidget * chooser_font_message;
  GtkWidget * chooser_font_list;
  GtkWidget * chooser_font_other;
  GtkWidget * label_attachment_folder;
  GtkWidget * chooser_attachment_folder;
  gint attachment_folder_signal_id;
  gint font_message_signal_id;
  gint font_list_signal_id;
  gint font_other_signal_id;
  
  g_object_get(table, "n-rows", &gline, NULL);
  line = gline;
  
  /* attachment folder */
  gtk_table_resize(GTK_TABLE(table), line + 1, 2);
  label_attachment_folder = gtk_label_new(_("Attachment Folder"));
  gtk_widget_show(label_attachment_folder);
  gtk_table_attach(GTK_TABLE(table), label_attachment_folder, 0, 1, line, line + 1,
      0, GTK_SHRINK, /* attach options */
      PADDING, PADDING);
  chooser_attachment_folder = gtk_file_chooser_button_new(_("Attachment Folder"),
      GTK_FILE_CHOOSER_ACTION_SELECT_FOLDER);
  gtk_widget_show(chooser_attachment_folder);
  gtk_table_attach(GTK_TABLE(table), chooser_attachment_folder, 1, 2, line, line + 1,
      GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, /* attach options */
      PADDING, PADDING);
  line ++;
  
  /* font */

  gtk_table_resize(GTK_TABLE(table), line + 1, 2);
  label_font_message = gtk_label_new(_("Font for Messages"));
  gtk_widget_show(label_font_message);
  gtk_table_attach(GTK_TABLE(table), label_font_message, 0, 1, line, line + 1,
      0, GTK_SHRINK, /* attach options */
      PADDING, PADDING);
  chooser_font_message = gtk_font_button_new();
  gtk_widget_show(chooser_font_message);
  gtk_table_attach(GTK_TABLE(table), chooser_font_message, 1, 2, line, line + 1,
      GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, /* attach options */
      PADDING, PADDING);
  line ++;
  
  gtk_table_resize(GTK_TABLE(table), line + 1, 2);
  label_font_list = gtk_label_new(_("Font for List"));
  gtk_widget_show(label_font_list);
  gtk_table_attach(GTK_TABLE(table), label_font_list, 0, 1, line, line + 1,
      0, GTK_SHRINK, /* attach options */
      PADDING, PADDING);
  chooser_font_list = gtk_font_button_new();
  gtk_widget_show(chooser_font_list);
  gtk_table_attach(GTK_TABLE(table), chooser_font_list, 1, 2, line, line + 1,
      GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, /* attach options */
      PADDING, PADDING);
  line ++;

  gtk_table_resize(GTK_TABLE(table), line + 1, 2);
  label_font_other = gtk_label_new(_("Font for Headers & Message Details"));
  gtk_widget_show(label_font_other);
  gtk_table_attach(GTK_TABLE(table), label_font_other, 0, 1, line, line + 1,
      0, GTK_SHRINK, /* attach options */
      PADDING, PADDING);
  chooser_font_other = gtk_font_button_new();
  gtk_widget_show(chooser_font_other);
  gtk_table_attach(GTK_TABLE(table), chooser_font_other, 1, 2, line, line + 1,
      GTK_EXPAND | GTK_SHRINK | GTK_FILL, 0, /* attach options */
      PADDING, PADDING);
  line ++;
  
  etpan_preferences_panel_set_widget(panel, "attachment-folder", chooser_attachment_folder);
  etpan_preferences_panel_set_widget(panel, "font-list", chooser_font_list);
  etpan_preferences_panel_set_widget(panel, "font-message", chooser_font_message);
  etpan_preferences_panel_set_widget(panel, "font-other", chooser_font_other);
  
  attachment_folder_signal_id = g_signal_connect(chooser_attachment_folder, "selection-changed",
      G_CALLBACK(attachment_folder_changed), panel);
  
  font_message_signal_id = g_signal_connect(chooser_font_message, "font-set",
      G_CALLBACK(font_message_changed), panel);
  font_other_signal_id = g_signal_connect(chooser_font_other, "font-set",
      G_CALLBACK(font_other_changed), panel);
  font_list_signal_id = g_signal_connect(chooser_font_list, "font-set",
      G_CALLBACK(font_list_changed), panel);
}

static GtkWidget * message_view_properties(struct etpan_preferences_panel * panel)
{
  GtkWidget * table;
  GtkWidget * scrolledwindow;
  
  table = gtk_table_new(1, 2, FALSE);
  
  message_view_properties_content(panel, table);
  
  gtk_widget_show(table);
  
  scrolledwindow = gtk_scrolled_window_new(NULL, NULL);
  gtk_scrolled_window_set_policy(GTK_SCROLLED_WINDOW(scrolledwindow),
      GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
  gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW(scrolledwindow),
      GTK_SHADOW_IN);
  
  gtk_scrolled_window_add_with_viewport(GTK_SCROLLED_WINDOW(scrolledwindow),
      table);
  gtk_widget_show(scrolledwindow);
  
  return scrolledwindow;
}

void etpan_preferences_view_init(struct etpan_preferences_window * preferences)
{
  GtkWidget * prop;
  struct etpan_preferences_panel * panel;
  
  panel = etpan_preferences_panel_new();
  if (panel == NULL)
    ETPAN_LOG_MEMORY_ERROR;

  panel->close_callback = panel_close;
  
  prop = message_view_properties(panel);
  
  panel->main_widget = prop;
  
#define ICON(name) \
  etpan_icon_manager_new_scaled_image(etpan_icon_manager_get_default(), \
      name, 32)
  etpan_preferences_add_page(preferences, _("View"), ICON("prefs-view"), panel);
#undef ICON
  
  setup_panel(panel);
}

static void setup_panel(struct etpan_preferences_panel * panel)
{
  char * attachment_folder;
  GtkWidget * chooser_folder;
  char * font_name;
  GtkWidget * font;
  
  attachment_folder = etpan_global_config_get_attachment_folder(etpan_global_config_get_default());
  
  chooser_folder = etpan_preferences_panel_get_widget(panel,
      "attachment-folder");
  
  gtk_file_chooser_set_filename(GTK_FILE_CHOOSER(chooser_folder),
      attachment_folder);
  
  font = etpan_preferences_panel_get_widget(panel, "font-message");
  font_name = etpan_ui_config_get_font_message(etpan_ui_config_get_default());
  gtk_font_button_set_font_name(GTK_FONT_BUTTON(font), font_name);
  
  font = etpan_preferences_panel_get_widget(panel, "font-list");
  font_name = etpan_ui_config_get_font_list(etpan_ui_config_get_default());
  gtk_font_button_set_font_name(GTK_FONT_BUTTON(font), font_name);
  
  font = etpan_preferences_panel_get_widget(panel, "font-other");
  font_name = etpan_ui_config_get_font_other(etpan_ui_config_get_default());
  gtk_font_button_set_font_name(GTK_FONT_BUTTON(font), font_name);
}

static void panel_close(struct etpan_preferences_panel * panel)
{
  struct etpan_error * error;
  (void) panel;
  
  error = etpan_ui_config_save_default();
  ETPAN_ERROR_IGNORE(error);
  
  error = etpan_global_config_save_default();
  ETPAN_ERROR_IGNORE(error);
}
