#ifndef ETPAN_PREFERENCES_WINDOW_H

#define ETPAN_PREFERENCES_WINDOW_H

#include "etpan-preferences-window-types.h"

struct etpan_preferences_window * etpan_preferences_window_new(void);
void etpan_preferences_window_free(struct etpan_preferences_window * preferences);


void etpan_preferences_add_page(struct etpan_preferences_window * preferences,
    char * text, GtkWidget * image, struct etpan_preferences_panel * panel);

struct etpan_preferences_panel * etpan_preferences_panel_new(void);
void etpan_preferences_panel_free(struct etpan_preferences_panel * panel);

void etpan_preferences_panel_set_widget(struct etpan_preferences_panel * panel,
    char * name, GtkWidget * widget);
GtkWidget * etpan_preferences_panel_get_widget(struct etpan_preferences_panel * panel, char * name);

GtkWidget * etpan_preferences_panel_get_main_widget(struct etpan_preferences_window * preferences);

struct etpan_preferences_window * etpan_preferences_window_get_default(void);
void etpan_preferences_window_set_default(struct etpan_preferences_window * preferences);

void etpan_preferences_window_setup(struct etpan_preferences_window * preferences);
void etpan_preferences_window_unsetup(struct etpan_preferences_window * preferences);

#endif
